<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!--
******************************************************************************************************************

	File for converted from Peppol Message Level Respose to OIOUBL Application Response

	Publisher:          Erhvervsstyrelsen
	Last changed by:    $Author: DanO $
	Last changed date:  $Date: 2023-10-08 $

	Description:		General conversion of the PEPPOL Message Level Respose to the danish OIOUBL syntax.

	Stylesheet version: 3.2.1.22ca3408

*****************************************************************************************************************
-->
<xsl:stylesheet xmlns="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2"
                xmlns:default="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2"
                xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
                xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0">
    
    
    <xsl:output method="xml" indent="yes"/>
    
    <xsl:template match="/">
        
        <xsl:choose>
            <xsl:when test="namespace-uri(/*) = 'urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2' and local-name(*) = 'ApplicationResponse'">
                
                <xsl:call-template name="BuildApplicationResponse"/>
            
            </xsl:when>
            <xsl:otherwise>
                
                <!-- Ikke korrekt dokument type-->
                <xsl:call-template name="Error"/>
            
            </xsl:otherwise>
        
        </xsl:choose>
    
    
    </xsl:template>
    
    
    <!--
         ************************************ Template *************************************************
    -->
    
    
    <xsl:template name="BuildApplicationResponse">
        
        <xsl:comment>------------------------------</xsl:comment>
        <xsl:comment>Converted from Peppol Message Level Response to an OIOUBL Application Response</xsl:comment>
        <xsl:comment>using the public XSLT conversion provided by Danish Business Authority.</xsl:comment>
        <xsl:comment>------------------------------</xsl:comment>
        
        <!-- Start of  OIOUBL ApplicationResponse -->
        <ApplicationResponse>
            
            <!-- Mandatory in OIOUBL -->
            <cbc:UBLVersionID>2.1</cbc:UBLVersionID>
            
            <!-- Mandatory in OIOUBL -->
            <cbc:CustomizationID>OIOUBL-2.1</cbc:CustomizationID>
            
            <!-- Default profile in OIOUBL -->
            <cbc:ProfileID schemeAgencyID="320" schemeID="urn:oioubl:id:profileid-1.5">
                <xsl:choose>
                    <xsl:when test="default:ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode = 'AB' or  default:ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode = 'AP'">Procurement-TecRes-1.0</xsl:when>
                    <xsl:otherwise>Procurement-BilSim-1.0</xsl:otherwise>
                </xsl:choose>
            </cbc:ProfileID>
           
            <cbc:ID>
                <xsl:value-of select="default:ApplicationResponse/cbc:ID"/>
            </cbc:ID>
            
            <cbc:IssueDate>
                <xsl:value-of select="default:ApplicationResponse/cbc:IssueDate"/>
            </cbc:IssueDate>
            
            <!-- Skab SenderParty segmentet -->
            <cac:SenderParty>
                <xsl:call-template name="EndpointIDSender"/>
            </cac:SenderParty>
            
            <!-- Skab ReceiverParty segmentet -->
            <cac:ReceiverParty>
                <xsl:call-template name="EndpointIDReceiver"/>
            </cac:ReceiverParty>
            
            <!-- Skab DocumentResponse segmentet -->
            <cac:DocumentResponse>
                <xsl:call-template name="DocumentResponse"/>
            </cac:DocumentResponse>
        
        </ApplicationResponse>
    </xsl:template>
    
    
    <!-- Sikre korrekt SchemaID for "Sender" i OIOUBL Application Response -->
    <xsl:template name="EndpointIDSender">
        <xsl:variable name="schemaIDMLR" select="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID/@schemeID"/>
        <xsl:variable name="schemaIDUBL">
            <xsl:choose>
                <xsl:when test="$schemaIDMLR = '0088'">GLN</xsl:when>
                <xsl:when test="$schemaIDMLR = '0096'">DK:P</xsl:when>
                <xsl:when test="$schemaIDMLR = '0184'">DK:CVR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0198'">DK:SE</xsl:when>
                <xsl:when test="$schemaIDMLR = '0007'">SE:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0060'">DUNS</xsl:when>
                <xsl:when test="$schemaIDMLR = '0192'">NO:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0212'">FI:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0213'">FI:VAT</xsl:when>
                <xsl:when test="$schemaIDMLR = '0037'">FI:OVT</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'DK:VANS'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- XML struktur -->
        <cbc:EndpointID schemeAgencyID="9" schemeID="{$schemaIDUBL}">
            <xsl:choose>
                <xsl:when test="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID/@schemeID = '0184' and not(starts-with(default:ApplicationResponse/cac:SenderParty/cbc:EndpointID, 'DK'))">
                    <xsl:value-of select="concat('DK', default:ApplicationResponse/cac:SenderParty/cbc:EndpointID)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID"/>
                </xsl:otherwise>
            </xsl:choose>
            
           <!-- <xsl:if test="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID/@schemeID = '0184'">DK<xsl:value-of select="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID"/></xsl:if-->
        </cbc:EndpointID>
        <cac:PartyName>
            <cbc:Name>
                <xsl:value-of select="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID"/>
            </cbc:Name>
        </cac:PartyName>
        <cac:PartyLegalEntity>
            <cbc:CompanyID schemeID="ZZZ">
                <xsl:value-of select="default:ApplicationResponse/cac:SenderParty/cbc:EndpointID"/>
            </cbc:CompanyID>
        </cac:PartyLegalEntity>
    
    </xsl:template>
    
    <!-- Sikre korrekt SchemaID for "Receiver" i OIOUBL Application Response -->
    <xsl:template name="EndpointIDReceiver">
        <xsl:variable name="schemaIDMLR" select="default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID/@schemeID"/>
        <xsl:variable name="schemaIDUBL">
            <xsl:choose>
                <xsl:when test="$schemaIDMLR = '0088'">GLN</xsl:when>
                <xsl:when test="$schemaIDMLR = '0096'">DK:P</xsl:when>
                <xsl:when test="$schemaIDMLR = '0184'">DK:CVR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0198'">DK:SE</xsl:when>
                <xsl:when test="$schemaIDMLR = '0007'">SE:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0060'">DUNS</xsl:when>
                <xsl:when test="$schemaIDMLR = '0192'">NO:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0212'">FI:ORGNR</xsl:when>
                <xsl:when test="$schemaIDMLR = '0213'">FI:VAT</xsl:when>
                <xsl:when test="$schemaIDMLR = '0037'">FI:OVT</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'DK:VANS'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- XML struktur -->
        <cbc:EndpointID schemeAgencyID="9" schemeID="{$schemaIDUBL}">
            <xsl:choose>
                <xsl:when test="default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID/@schemeID = '0184'  and not(starts-with(default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID, 'DK'))">
                    <xsl:value-of select="concat('DK', default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID"/>
                </xsl:otherwise>
            </xsl:choose>
        </cbc:EndpointID>
        <cac:PartyName>
            <cbc:Name>
                <xsl:value-of select="default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID"/>
            </cbc:Name>
        </cac:PartyName>
        <cac:PartyLegalEntity>
            <cbc:CompanyID schemeID="ZZZ">
                <xsl:value-of select="default:ApplicationResponse/cac:ReceiverParty/cbc:EndpointID"/>
            </cbc:CompanyID>
        </cac:PartyLegalEntity>
    
    </xsl:template>
    
    
    <!-- Konverter Peppol Response Code til valid OIOUBL Application Response Code-->
    <xsl:template name="DocumentResponse">
        
        <xsl:variable name="ResponseCode" select="default:ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode"/>
        <xsl:variable name="UBLResponseCode">
            <xsl:choose>
                <xsl:when test="$ResponseCode = 'AP'">TechnicalAccept</xsl:when>
                <xsl:when test="$ResponseCode = 'AB'">TechnicalAccept</xsl:when>
                <xsl:when test="$ResponseCode = 'RE'">TechnicalReject</xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        
        <xsl:variable name="DocumentTypeCode" select="default:ApplicationResponse/cac:DocumentResponse/cac:DocumentReference/cbc:DocumentTypeCode"/>
        <xsl:variable name="UBLDocumentTypeCode">
            <xsl:choose>
                <xsl:when test="$DocumentTypeCode = '380'">Invoice</xsl:when>
                <xsl:when test="$DocumentTypeCode = '381'">CreditNote</xsl:when>
                <xsl:when test="$DocumentTypeCode = '71'">Reminder</xsl:when>
                <xsl:when test="$DocumentTypeCode = '54'">Statement</xsl:when>
                
                <xsl:when test="$DocumentTypeCode = '9'">Catalogue</xsl:when>
                
                <xsl:when test="$DocumentTypeCode = '220'">Order</xsl:when>
                <xsl:when test="$DocumentTypeCode = '231'">OrderResponse</xsl:when>
                <xsl:when test="$DocumentTypeCode = '230'">OrderChange</xsl:when>
                
                <xsl:when test="$DocumentTypeCode = '164'">UtilityStatement</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'ApplicationResponse'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- XML struktur -->
        <cac:Response>
            <cbc:ReferenceID>1</cbc:ReferenceID>
            <cbc:ResponseCode listAgencyID="320" listID="urn:oioubl:codelist:responsecode-1.1">
                <xsl:value-of select="$UBLResponseCode"/>
            </cbc:ResponseCode>
            <cbc:Description>
                <xsl:value-of select="default:ApplicationResponse/cac:DocumentResponse/cac:Response/Description"/>
            </cbc:Description>
        </cac:Response>
        
        <cac:DocumentReference>
            <cbc:ID>
                <xsl:value-of select="default:ApplicationResponse/cac:DocumentResponse/cac:DocumentReference/cbc:ID"/>
            </cbc:ID>
            <cbc:DocumentTypeCode listAgencyID="320" listID="urn:oioubl:codelist:responsedocumenttypecode-1.2">
                <xsl:value-of select="$UBLDocumentTypeCode"/>
            </cbc:DocumentTypeCode>
        </cac:DocumentReference>
        
        <xsl:for-each select="default:ApplicationResponse/cac:DocumentResponse/cac:LineResponse">
            
            <xsl:variable name="ResponseCodeLine" select="cac:Response/cbc:ResponseCode"/>
            <xsl:variable name="UBLResponseCodeLine">
                <xsl:choose>
                    <xsl:when test="$ResponseCode = 'AP'">BusinessAccept</xsl:when>
                    <xsl:when test="$ResponseCode = 'AB'">BusinessAccept</xsl:when>
                    <xsl:when test="$ResponseCode = 'RE'">BusinessReject</xsl:when>
                </xsl:choose>
            </xsl:variable>
            
            
            <xsl:variable name="ResponseStatusLine" select="cac:Response/cac:Status/cbc:StatusReasonCode"/>
            <xsl:variable name="UBLResponseLine">
                <xsl:choose>
                    <xsl:when test="$ResponseStatusLine = 'BV'">BusinessReject</xsl:when>
                    <xsl:when test="$ResponseStatusLine = 'BW'">BusinessAccept</xsl:when>
                    <xsl:when test="$ResponseStatusLine = 'SV'">BusinessReject</xsl:when>
                </xsl:choose>
            </xsl:variable>
            
            
            <cac:LineResponse>
                <cac:LineReference>
                    <cbc:LineID>
                        <xsl:value-of select="cac:LineReference/cbc:LineID"/>
                    </cbc:LineID>
                </cac:LineReference>
                <cac:Response>
                    <cbc:ReferenceID><xsl:value-of select="position()"/></cbc:ReferenceID>
                    <cbc:ResponseCode listAgencyID="320" listID="urn:oioubl:codelist:lineresponsecode-1.1">
                        <xsl:value-of select="$UBLResponseCodeLine"/>
                    </cbc:ResponseCode>
                    <cbc:Description>
                        <xsl:value-of select="cac:Response/cbc:Description"/>
                    </cbc:Description>
                    <cac:Status>
                        <cbc:StatusReasonCode>
                            <xsl:value-of select="$UBLResponseLine"/>
                        </cbc:StatusReasonCode>
                    </cac:Status>
                </cac:Response>
            </cac:LineResponse>
        
        </xsl:for-each>
    
    </xsl:template>
    
    
    <!-- Fejlmeddelelse hvis det ikke er en korrete dokumenttype (Rodelement og NameSpace -->
    <xsl:template name="Error">
        
        <Error>
            <Beskrivelse>[F-APPRES001] Root element and/or NameSpace are invalid</Beskrivelse>
            <NameSpace>
                <Forventer>urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2'</Forventer>
                <Fundet>
                    <xsl:value-of select="namespace-uri(/*)"/>
                </Fundet>
            </NameSpace>
            
            <RootElement>
                <Forventer>ApplicationResponse</Forventer>
                <Fundet>
                    <xsl:value-of select="local-name(*)"/>
                </Fundet>
            </RootElement>
        </Error>
    
    </xsl:template>

</xsl:stylesheet>
